import java.io.*;
import java.net.*;
import java.sql.*;
import java.util.*;

// INTERFACE DE CONNECTION VERS JDBC
// AUTEUR: Olivier Auverlot
// VERSION: 1.3


class jdbcThread extends Thread {
	private Socket socket;
	private BufferedReader in;
	private PrintWriter out;
	private Connection conn = null;
	private int errorCode = 0;

	private String userRequest;
	private String user;
	private String password;
	private String database;

	private StringBuffer buffer = new StringBuffer();
 
	public jdbcThread(Socket s) throws IOException {
		socket = s;
		start();
	}


	// ---------------------------------------------------
	// CONNECTION A LA BASE selon la chaine de parametrage
	// renvoie TRUE ou FALSE selon reussite/echec
	// ---------------------------------------------------
	private boolean connectToDatabase() {
                try {
                       	conn = DriverManager.getConnection(database,user,password);
				return(true);
                }
                catch(SQLException e) {
				errorCode = e.getErrorCode();
                       	return(false);
                }
	}

	// -----------------------------------
	// EXECUTION DE LA REQUETE UTILISATEUR
	// -----------------------------------
	private boolean executeSQLrequest(String userRequest) {
		ResultSet resultat;
		long nbrLignes;
		int i;

        	try {
			Statement requete = conn.createStatement();

			if (requete.execute(userRequest)) {
				resultat = requete.getResultSet();
				
				// boucle
				final int nbr_columns = resultat.getMetaData().getColumnCount();

                       	while(resultat.next()) {
                       		for(i=1; i <= nbr_columns; i++) {
                  			try {
							buffer.append(resultat.getString(i).trim());
						} catch (Exception e2) {}
						buffer.append("|");
					}
                       	}
                       	resultat.close();
			} else {
				nbrLignes = requete.getUpdateCount();
				if (nbrLignes != -1) {
					buffer.append(nbrLignes);
				} 
				buffer.append("|");
			}

			requete.close();
			return(true);
                }
                catch(SQLException e) {
			errorCode = e.getErrorCode();
			return(false);
                }
	}

	private boolean closeDatabase() {
		try {
			conn.close();
			return(true);
		}
		catch (SQLException e) {
			errorCode = e.getErrorCode();
			return(false);
		}
	}

	private void sendErrorMessage() {
 	       buffer.append("!!ERROR").append(errorCode);
	       out.println(buffer);	
	}

	public final void run() {
		StringTokenizer arg;
		try {

			in = new BufferedReader(new InputStreamReader (socket.getInputStream()));
			out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())),true);
			
			arg = new StringTokenizer(in.readLine(),"|");
			database = arg.nextToken();
			user = arg.nextToken();
			password = arg.nextToken();
			userRequest = arg.nextToken();

			System.out.println(database);
			System.out.println(user);
			System.out.println(password);
			System.out.println(userRequest);

			if (connectToDatabase()) {
				if (executeSQLrequest(userRequest)) {
					out.println(buffer);
				} else { sendErrorMessage(); }
				if (closeDatabase() == false) { sendErrorMessage(); }
			} else { sendErrorMessage(); }
		} 
		catch (IOException e) {}
		finally {
			try {
				socket.close(); 
			} 
			catch(IOException e) {}
		}
	}
}

public class jdbcbridge {
	static final int PORT = 8000;

	private static void connexionJdbc() {
		// CHARGEMENT DU PILOTE JDBC
           	try {
           		Class.forName("org.gjt.mm.mysql.Driver").newInstance();
           	}
           	catch(Exception e) {
           		System.out.println("Impossible de charger le driver JDBC");
	            System.exit(1);
          	}
	}


	public static void main(String[] args) throws IOException {

		connexionJdbc();

		ServerSocket s = new ServerSocket(PORT);
		System.out.println("Serveur en attente...");
		
		try {	
			while(true) {
				Socket socket = s.accept();
				try {
					new jdbcThread(socket);
				} catch (IOException e) {
					socket.close();
				}
			}
		} finally {
			s.close();
		}
	}
}	
